<?php
require_once __DIR__ . '/config.php';
require_login();
require_role('admin');

// Fetch users summary
$users = $db->query("SELECT id, name, email, role, created_at FROM users ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
$devices = $db->query("SELECT d.*, u.name AS owner_name FROM devices d JOIN users u ON u.id = d.owner_id ORDER BY d.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
$bookings = $db->query("SELECT b.*, d.title, u.name AS advertiser_name 
    FROM bookings b 
    JOIN devices d ON d.id = b.device_id
    JOIN users u ON u.id = b.user_id
    ORDER BY b.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/header.php';
?>
<div class="container">
    <h2>Admin Prisa Static</h2>
    <p>Resumen de usuarios, inventario y reservas.</p>

    <h3>Usuarios</h3>
    <table>
        <tr>
            <th>Nombre</th>
            <th>Email</th>
            <th>Rol</th>
            <th>Alta</th>
        </tr>
        <?php foreach ($users as $u): ?>
            <tr>
                <td><?php echo htmlspecialchars($u['name']); ?></td>
                <td><?php echo htmlspecialchars($u['email']); ?></td>
                <td><?php echo htmlspecialchars($u['role']); ?></td>
                <td><?php echo htmlspecialchars($u['created_at']); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3>Inventario</h3>
    <table>
        <tr>
            <th>Título</th>
            <th>Owner</th>
            <th>Tipo</th>
            <th>Ubicación</th>
            <th>Tarifa mensual</th>
        </tr>
        <?php foreach ($devices as $d): ?>
            <tr>
                <td><?php echo htmlspecialchars($d['title']); ?></td>
                <td><?php echo htmlspecialchars($d['owner_name']); ?></td>
                <td><?php echo htmlspecialchars($d['type']); ?></td>
                <td><?php echo htmlspecialchars($d['address']); ?></td>
                <td>
                    <?php if ($d['price_month']): ?>
                        ARS <?php echo number_format($d['price_month'], 0, ',', '.'); ?>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3>Reservas</h3>
    <table>
        <tr>
            <th>Soporte</th>
            <th>Anunciante</th>
            <th>Desde</th>
            <th>Hasta</th>
            <th>Total</th>
            <th>Estado</th>
        </tr>
        <?php foreach ($bookings as $b): ?>
            <tr>
                <td><?php echo htmlspecialchars($b['title']); ?></td>
                <td><?php echo htmlspecialchars($b['advertiser_name']); ?></td>
                <td><?php echo htmlspecialchars($b['start_date']); ?></td>
                <td><?php echo htmlspecialchars($b['end_date']); ?></td>
                <td>ARS <?php echo number_format($b['total_price'], 0, ',', '.'); ?></td>
                <td><span class="tag"><?php echo htmlspecialchars($b['status']); ?></span></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
<?php include __DIR__ . '/footer.php'; ?>
