<?php
require_once __DIR__ . '/config.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$id) {
    header('Location: index.php');
    exit();
}

$stmt = $db->prepare("SELECT d.*, u.name AS owner_name, u.email AS owner_email 
    FROM devices d 
    JOIN users u ON u.id = d.owner_id
    WHERE d.id = :id LIMIT 1");
$stmt->execute([':id' => $id]);
$device = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$device) {
    header('Location: index.php');
    exit();
}

// Fetch bookings for calendar note (just to show booked ranges)
$stmt2 = $db->prepare("SELECT start_date, end_date, status FROM bookings WHERE device_id = :id AND status IN ('pending','confirmed')");
$stmt2->execute([':id' => $id]);
$bookings = $stmt2->fetchAll(PDO::FETCH_ASSOC);

$user = current_user();

include __DIR__ . '/header.php';
?>
<div class="container">
    <div class="device-main">
        <div>
            <?php if (!empty($device['main_image']) && file_exists(__DIR__ . '/uploads/' . $device['main_image'])): ?>
                <img src="<?php echo 'uploads/' . htmlspecialchars($device['main_image']); ?>" alt="">
            <?php else: ?>
                <img src="https://via.placeholder.com/800x500?text=Prisa+Static" alt="">
            <?php endif; ?>
            <div class="box" style="margin-top:16px;">
                <h3>Descripción</h3>
                <p><?php echo nl2br(htmlspecialchars($device['description'])); ?></p>
                <p class="meta">
                    <strong>Ubicación:</strong> <?php echo htmlspecialchars($device['address']); ?><br>
                    <strong>Tipo:</strong> <?php echo htmlspecialchars($device['type']); ?><br>
                    <?php if ($device['width'] && $device['height']): ?>
                        <strong>Medidas:</strong> <?php echo htmlspecialchars($device['width'] . ' x ' . $device['height']); ?> m<br>
                    <?php endif; ?>
                    <strong>Media owner:</strong> <?php echo htmlspecialchars($device['owner_name']); ?>
                </p>

                <?php if (!empty($device['address'])): ?>
                    <h3>Mapa de ubicación</h3>
                    <div class="map-container">
                        <div id="mapView"></div>
                    </div>
                    <p class="calendar-note">La ubicación es referencial para orientar al anunciante sobre la zona del soporte.</p>
                <?php endif; ?>
            </div>
        </div>
        <div>
            <div class="box">
                <h3>Tarifas</h3>
                <p>
                    <?php if ($device['price_month']): ?>
                        <strong>Mensual:</strong> ARS <?php echo number_format($device['price_month'], 0, ',', '.'); ?><br>
                    <?php endif; ?>
                    <?php if ($device['price_week']): ?>
                        <strong>Semanal:</strong> ARS <?php echo number_format($device['price_week'], 0, ',', '.'); ?><br>
                    <?php endif; ?>
                    <?php if ($device['price_day']): ?>
                        <strong>Diaria:</strong> ARS <?php echo number_format($device['price_day'], 0, ',', '.'); ?><br>
                    <?php endif; ?>
                    <?php if (!$device['price_month'] && !$device['price_week'] && !$device['price_day']): ?>
                        Consultar tarifa con el media owner.
                    <?php endif; ?>
                </p>

                <div class="booking-panel">
                    <h3>Reserva</h3>
                    <p>Elegí las fechas deseadas y generá una solicitud de reserva. El media owner deberá aceptarla y luego <strong>Prisa Static</strong> gestionará el pago por <strong>cuenta corriente</strong> o <strong>transferencia bancaria</strong>.</p>
                    <?php if ($user): ?>
                        <form method="post" action="booking_new.php">
                            <input type="hidden" name="device_id" value="<?php echo (int)$device['id']; ?>">
                            <div class="booking-row">
                                <div style="flex:1;">
                                    <label>Desde</label>
                                    <input type="date" name="start_date" required>
                                </div>
                                <div style="flex:1;">
                                    <label>Hasta</label>
                                    <input type="date" name="end_date" required>
                                </div>
                                <div>
                                    <button type="submit" class="btn-primary-solid">Solicitar reserva</button>
                                </div>
                            </div>
                        </form>
                    <?php else: ?>
                        <p><a href="login.php" class="badge">Ingresá</a> o <a href="register.php" class="badge">creá una cuenta</a> para reservar.</p>
                    <?php endif; ?>
                </div>

                <p class="calendar-note">
                    Rangos ya reservados / pendientes:
                    <?php if (!$bookings): ?>
                        <br>No hay reservas registradas aún.
                    <?php else: ?>
                        <ul>
                            <?php foreach ($bookings as $b): ?>
                                <li><?php echo htmlspecialchars($b['start_date']); ?> a <?php echo htmlspecialchars($b['end_date']); ?> (<?php echo htmlspecialchars($b['status']); ?>)</li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                </p>

                <h3>Contacto</h3>
                <p>Una vez generada la reserva, podés coordinar condiciones comerciales y facturación con el media owner:<br>
                    <strong>Email:</strong> <?php echo htmlspecialchars($device['owner_email']); ?>
                </p>
            </div>
        </div>
    </div>
</div>

<?php if (!empty($device['address'])): ?>
<script>
// Token de Mapbox: reemplazar por el tuyo
const MAPBOX_TOKEN_VIEW = 'TU_TOKEN_DE_MAPBOX_AQUI';

document.addEventListener('DOMContentLoaded', function () {
    if (!MAPBOX_TOKEN_VIEW || MAPBOX_TOKEN_VIEW === 'TU_TOKEN_DE_MAPBOX_AQUI') {
        console.warn('Configurar token de Mapbox en device_view.php para mostrar el mapa.');
        return;
    }
    if (!document.getElementById('mapView')) return;

    mapboxgl.accessToken = MAPBOX_TOKEN_VIEW;
    const defaultCenter = [-58.3816, -34.6037]; // CABA
    const mapView = new mapboxgl.Map({
        container: 'mapView',
        style: 'mapbox://styles/mapbox/streets-v11',
        center: defaultCenter,
        zoom: 10
    });

    const hasCoords = <?php echo (!empty($device['lat']) && !empty($device['lng'])) ? 'true' : 'false'; ?>;

    if (hasCoords) {
        const lng = <?php echo $device['lng'] ?: '-58.3816'; ?>;
        const lat = <?php echo $device['lat'] ?: '-34.6037'; ?>;
        const marker = new mapboxgl.Marker().setLngLat([lng, lat]).addTo(mapView);
        mapView.setCenter([lng, lat]);
        mapView.setZoom(14);
    } else {
        const address = <?php echo json_encode($device['address']); ?>;
        const url = 'https://api.mapbox.com/geocoding/v5/mapbox.places/' + encodeURIComponent(address) + '.json?limit=1&access_token=' + MAPBOX_TOKEN_VIEW;
        fetch(url)
            .then(r => r.json())
            .then(data => {
                if (!data.features || !data.features.length) return;
                const [lng, lat] = data.features[0].center;
                new mapboxgl.Marker().setLngLat([lng, lat]).addTo(mapView);
                mapView.setCenter([lng, lat]);
                mapView.setZoom(14);
            })
            .catch(() => {});
    }
});
</script>
<?php endif; ?>

<?php include __DIR__ . '/footer.php'; ?>
