<?php
require_once __DIR__ . '/config.php';

// Filters
$where = [];
$params = [];

if (!empty($_GET['q'])) {
    $where[] = '(title LIKE :q OR address LIKE :q OR description LIKE :q)';
    $params[':q'] = '%' . $_GET['q'] . '%';
}

if (!empty($_GET['type'])) {
    $where[] = 'type = :type';
    $params[':type'] = $_GET['type'];
}

$sql = "SELECT d.*, u.name AS owner_name FROM devices d 
        JOIN users u ON u.id = d.owner_id";

if ($where) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$sql .= " ORDER BY d.created_at DESC";

$stmt = $db->prepare($sql);
$stmt->execute($params);
$devices = $stmt->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/header.php';
?>
<div class="container">
    <div class="hero">
        <div>
            <h1>Explorá soportes estáticos en todo el país</h1>
            <p>Inventario profesional de vallas, refugios, mupis y más. Prisa Static centraliza reservas y pagos por cuenta corriente o transferencia bancaria.</p>
            <div class="chips">
                <span class="chip">Gestión de pagos por Prisa</span>
                <span class="chip">Media owners verificados</span>
                <span class="chip">Reservas por período</span>
            </div>
        </div>
    </div>

    <form class="filter-bar" method="get">
        <input type="text" name="q" placeholder="Buscar por dirección, ciudad, descripción..." value="<?php echo isset($_GET['q']) ? htmlspecialchars($_GET['q']) : ''; ?>">
        <select name="type">
            <option value="">Tipo de soporte</option>
            <?php
            $types = ['Valla', 'Refugio', 'Mupi', 'Frontlight', 'Backlight', 'Gigantografía'];
            foreach ($types as $t):
                $sel = (isset($_GET['type']) && $_GET['type'] === $t) ? 'selected' : '';
                echo '<option value="' . htmlspecialchars($t) . '" ' . $sel . '>' . htmlspecialchars($t) . '</option>';
            endforeach;
            ?>
        </select>
        <button type="submit">Filtrar</button>
    </form>

    <div class="grid">
        <?php if (!$devices): ?>
            <p>No hay soportes publicados todavía.</p>
        <?php endif; ?>
        <?php foreach ($devices as $d): ?>
            <a class="card" href="device_view.php?id=<?php echo (int)$d['id']; ?>">
                <?php if (!empty($d['main_image']) && file_exists(__DIR__ . '/uploads/' . $d['main_image'])): ?>
                    <img src="<?php echo 'uploads/' . htmlspecialchars($d['main_image']); ?>" alt="">
                <?php else: ?>
                    <img src="https://via.placeholder.com/600x400?text=Prisa+Static" alt="">
                <?php endif; ?>
                <div class="card-body">
                    <div class="card-title"><?php echo htmlspecialchars($d['title']); ?></div>
                    <div class="card-sub">
                        <?php echo htmlspecialchars($d['address']); ?>
                    </div>
                    <div class="card-sub">
                        <span class="badge"><?php echo htmlspecialchars($d['type']); ?></span>
                        <?php if ($d['width'] && $d['height']): ?>
                            · <?php echo htmlspecialchars($d['width'] . 'x' . $d['height']); ?> m
                        <?php endif; ?>
                    </div>
                    <div class="card-price">
                        <?php if ($d['price_month']): ?>
                            ARS <?php echo number_format($d['price_month'], 0, ',', '.'); ?> / mes
                        <?php elseif ($d['price_week']): ?>
                            ARS <?php echo number_format($d['price_week'], 0, ',', '.'); ?> / semana
                        <?php elseif ($d['price_day']): ?>
                            ARS <?php echo number_format($d['price_day'], 0, ',', '.'); ?> / día
                        <?php else: ?>
                            Consultar tarifa
                        <?php endif; ?>
                    </div>
                </div>
            </a>
        <?php endforeach; ?>
    </div>
</div>
<?php include __DIR__ . '/footer.php'; ?>
