<?php
require_once __DIR__ . '/config.php';
require_login();
require_role('admin');

// Cambiar estado de usuarios
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_id'], $_POST['new_status'])) {
    $uid = (int)$_POST['user_id'];
    $newStatus = in_array($_POST['new_status'], ['approved','pending','blocked']) ? $_POST['new_status'] : 'pending';
    $stmtU = $db->prepare("UPDATE users SET status = :status WHERE id = :id");
    $stmtU->execute([':status' => $newStatus, ':id' => $uid]);
}

// Fetch users summary
$users = $db->query("SELECT id, name, email, role, status, created_at FROM users ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
$devices = $db->query("SELECT d.*, u.name AS owner_name FROM devices d JOIN users u ON u.id = d.owner_id ORDER BY d.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
$bookings = $db->query("SELECT b.*, d.title, u.name AS advertiser_name 
    FROM bookings b 
    JOIN devices d ON d.id = b.device_id
    JOIN users u ON u.id = b.user_id
    ORDER BY b.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/header.php';
?>
<div class="container">
    <h2>Admin Prisa Static</h2>
    <p>Resumen de usuarios, inventario y reservas.</p>

    <h3>Usuarios</h3>
    <table>
        <tr>
            <th>Nombre</th>
            <th>Email</th>
            <th>Rol</th>
            <th>Estado</th>
            <th>Alta</th>
            <th>Acciones</th>
        </tr>
        <?php foreach ($users as $u): ?>
            <tr>
                <td><?php echo htmlspecialchars($u['name']); ?></td>
                <td><?php echo htmlspecialchars($u['email']); ?></td>
                <td><?php echo htmlspecialchars($u['role']); ?></td>
                <td><span class="tag"><?php echo htmlspecialchars($u['status'] ?? 'approved'); ?></span></td>
                <td><?php echo htmlspecialchars($u['created_at']); ?></td>
                <td>
                    <form method="post" style="display:inline-block;">
                        <input type="hidden" name="user_id" value="<?php echo (int)$u['id']; ?>">
                        <?php if (($u['status'] ?? 'approved') !== 'approved'): ?>
                            <button type="submit" name="new_status" value="approved" class="btn-secondary">Aprobar</button>
                        <?php endif; ?>
                        <?php if (($u['status'] ?? 'approved') !== 'blocked'): ?>
                            <button type="submit" name="new_status" value="blocked" class="btn-secondary">Bloquear</button>
                        <?php endif; ?>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3>Configuración de plataforma</h3>
    <p>Definí logo, datos de contacto y texto institucional de Prisa Static.</p>
    <p><a href="admin_settings.php" class="badge">Abrir configuración avanzada</a></p>

    <h3>Inventario</h3>
    <table>
        <tr>
            <th>Título</th>
            <th>Owner</th>
            <th>Tipo</th>
            <th>Ubicación</th>
            <th>Tarifa mensual</th>
        </tr>
        <?php foreach ($devices as $d): ?>
            <tr>
                <td><?php echo htmlspecialchars($d['title']); ?></td>
                <td><?php echo htmlspecialchars($d['owner_name']); ?></td>
                <td><?php echo htmlspecialchars($d['type']); ?></td>
                <td><?php echo htmlspecialchars($d['address']); ?></td>
                <td>
                    <?php if ($d['price_month']): ?>
                        ARS <?php echo number_format($d['price_month'], 0, ',', '.'); ?>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3>Reservas</h3>
    <table>
        <tr>
            <th>Soporte</th>
            <th>Anunciante</th>
            <th>Desde</th>
            <th>Hasta</th>
            <th>Total</th>
            <th>Estado</th>
        </tr>
        <?php foreach ($bookings as $b): ?>
            <tr>
                <td><?php echo htmlspecialchars($b['title']); ?></td>
                <td><?php echo htmlspecialchars($b['advertiser_name']); ?></td>
                <td><?php echo htmlspecialchars($b['start_date']); ?></td>
                <td><?php echo htmlspecialchars($b['end_date']); ?></td>
                <td>ARS <?php echo number_format($b['total_price'], 0, ',', '.'); ?></td>
                <td><span class="tag"><?php echo htmlspecialchars($b['status']); ?></span></td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
<?php include __DIR__ . '/footer.php'; ?>
