<?php
require_once __DIR__ . '/config.php';
require_login();
require_role('admin');

// cargar settings
$stmt = $db->query("SELECT * FROM settings WHERE id = 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$settings) {
    $db->exec("INSERT INTO settings (id, platform_name) VALUES (1, 'Prisa Static')");
    $stmt = $db->query("SELECT * FROM settings WHERE id = 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $platform_name = trim($_POST['platform_name'] ?? '');
    $contact_email = trim($_POST['contact_email'] ?? '');
    $contact_phone = trim($_POST['contact_phone'] ?? '');
    $billing_info = trim($_POST['billing_info'] ?? '');
    $about_html = trim($_POST['about_html'] ?? '');
    $logo_path = $settings['logo_path'] ?? null;

    if (!is_dir(__DIR__ . '/uploads')) {
        mkdir(__DIR__ . '/uploads', 0775, true);
    }

    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['logo']['tmp_name'];
        $name = basename($_FILES['logo']['name']);
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg','jpeg','png','webp','svg'])) {
            $newName = 'logo_prisa_static.' . $ext;
            $dest = __DIR__ . '/uploads/' . $newName;
            if (move_uploaded_file($tmp, $dest)) {
                $logo_path = 'uploads/' . $newName;
            }
        }
    }

    $stmtU = $db->prepare("UPDATE settings SET platform_name = :platform_name, contact_email = :contact_email, contact_phone = :contact_phone, billing_info = :billing_info, about_html = :about_html, logo_path = :logo_path WHERE id = 1");
    $stmtU->execute([
        ':platform_name' => $platform_name ?: 'Prisa Static',
        ':contact_email' => $contact_email,
        ':contact_phone' => $contact_phone,
        ':billing_info' => $billing_info,
        ':about_html' => $about_html,
        ':logo_path' => $logo_path
    ]);

    $success = 'Configuración actualizada correctamente.';
    $stmt = $db->query("SELECT * FROM settings WHERE id = 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
}

include __DIR__ . '/header.php';
?>
<div class="container">
    <div class="box">
        <h2>Configuración de Prisa Static</h2>
        <p>Definí los datos generales de la plataforma.</p>

        <?php if ($error): ?>
            <div class="alert error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data" class="standard" style="max-width:100%;box-shadow:none;border:none;padding:0;">
            <label>Nombre de la plataforma</label>
            <input type="text" name="platform_name" value="<?php echo htmlspecialchars($settings['platform_name'] ?? 'Prisa Static'); ?>">

            <label>Logo (PNG/JPG/SVG)</label>
            <input type="file" name="logo" accept="image/*">
            <?php if (!empty($settings['logo_path']) && file_exists(__DIR__ . '/' . $settings['logo_path'])): ?>
                <p class="calendar-note">Logo actual:</p>
                <img src="<?php echo htmlspecialchars($settings['logo_path']); ?>" alt="Logo" style="max-height:60px;">
            <?php endif; ?>

            <label>Email de contacto comercial</label>
            <input type="email" name="contact_email" value="<?php echo htmlspecialchars($settings['contact_email'] ?? ''); ?>">

            <label>Teléfono de contacto</label>
            <input type="text" name="contact_phone" value="<?php echo htmlspecialchars($settings['contact_phone'] ?? ''); ?>">

            <label>Datos de facturación / pie de página</label>
            <textarea name="billing_info" rows="3"><?php echo htmlspecialchars($settings['billing_info'] ?? ''); ?></textarea>

            <label>Texto institucional (HTML básico permitido)</label>
            <textarea name="about_html" rows="4"><?php echo htmlspecialchars($settings['about_html'] ?? ''); ?></textarea>

            <button type="submit">Guardar configuración</button>
        </form>

        <p style="margin-top:12px;"><a href="admin_dashboard.php" class="badge">Volver al panel admin</a></p>
    </div>
</div>
<?php include __DIR__ . '/footer.php'; ?>
