<?php
require_once __DIR__ . '/config.php';
require_login();
require_role('owner');

$user = current_user();

$device_id = isset($_GET['device_id']) ? (int)$_GET['device_id'] : 0;
if (!$device_id) {
    header('Location: owner_dashboard.php');
    exit();
}

// Verificar que el dispositivo pertenece a este owner
$stmt = $db->prepare("SELECT * FROM devices WHERE id = :id AND owner_id = :owner LIMIT 1");
$stmt->execute([':id' => $device_id, ':owner' => $user['id']]);
$device = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$device) {
    header('Location: owner_dashboard.php');
    exit();
}

$error = '';
$success = '';

// Alta de rango disponible
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['start_date'], $_POST['end_date']) && !isset($_POST['delete_id'])) {
    $start = $_POST['start_date'];
    $end = $_POST['end_date'];

    if (!$start || !$end) {
        $error = 'Completá ambas fechas.';
    } else {
        if ($end < $start) {
            $tmp = $start;
            $start = $end;
            $end = $tmp;
        }

        $stmtIns = $db->prepare("INSERT INTO availability (device_id, start_date, end_date) VALUES (:device_id, :start_date, :end_date)");
        $stmtIns->execute([
            ':device_id' => $device_id,
            ':start_date' => $start,
            ':end_date' => $end
        ]);
        $success = 'Rango de disponibilidad agregado.';
    }
}

// Borrar rango disponible
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_id'])) {
    $delId = (int)$_POST['delete_id'];
    $stmtDel = $db->prepare("DELETE FROM availability WHERE id = :id AND device_id = :device_id");
    $stmtDel->execute([':id' => $delId, ':device_id' => $device_id]);
    $success = 'Rango de disponibilidad eliminado.';
}

$stmt2 = $db->prepare("SELECT * FROM availability WHERE device_id = :device_id ORDER BY start_date ASC");
$stmt2->execute([':device_id' => $device_id]);
$ranges = $stmt2->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/header.php';
?>
<div class="container">
    <div class="box">
        <h2>Disponibilidad de soporte</h2>
        <p><strong><?php echo htmlspecialchars($device['title']); ?></strong><br>
        <?php echo htmlspecialchars($device['address']); ?></p>

        <?php if ($error): ?>
            <div class="alert error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <h3>Agregar rango disponible</h3>
        <form method="post" class="standard" style="max-width:100%;box-shadow:none;border:none;padding:0;">
            <label>Desde</label>
            <input type="date" name="start_date" required>
            <label>Hasta</label>
            <input type="date" name="end_date" required>
            <button type="submit">Agregar disponibilidad</button>
        </form>

        <h3>Rangos cargados</h3>
        <?php if (!$ranges): ?>
            <p class="calendar-note">Si no cargás rangos, el sistema asumirá que el soporte está disponible en cualquier fecha libre de reservas.</p>
        <?php else: ?>
            <table>
                <tr>
                    <th>Desde</th>
                    <th>Hasta</th>
                    <th>Acciones</th>
                </tr>
                <?php foreach ($ranges as $r): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($r['start_date']); ?></td>
                        <td><?php echo htmlspecialchars($r['end_date']); ?></td>
                        <td>
                            <form method="post" onsubmit="return confirm('¿Eliminar este rango?');">
                                <input type="hidden" name="delete_id" value="<?php echo (int)$r['id']; ?>">
                                <button type="submit" class="btn-secondary">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php endif; ?>

        <p style="margin-top:12px;"><a href="owner_dashboard.php" class="badge">Volver al panel de media owner</a></p>
    </div>
</div>
<?php include __DIR__ . '/footer.php'; ?>
