<?php
require_once __DIR__ . '/config.php';
require_login();

$user = current_user();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit();
}

$device_id = isset($_POST['device_id']) ? (int)$_POST['device_id'] : 0;
$start_date = $_POST['start_date'] ?? '';
$end_date = $_POST['end_date'] ?? '';

if (!$device_id || !$start_date || !$end_date) {
    header('Location: device_view.php?id=' . $device_id);
    exit();
}

$stmt = $db->prepare("SELECT * FROM devices WHERE id = :id LIMIT 1");
$stmt->execute([':id' => $device_id]);
$device = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$device) {
    header('Location: index.php');
    exit();
}

// Normalizar fechas
$sd = strtotime($start_date);
$ed = strtotime($end_date);
if ($ed < $sd) {
    $tmp = $sd;
    $sd = $ed;
    $ed = $tmp;
    $start_date = date('Y-m-d', $sd);
    $end_date = date('Y-m-d', $ed);
}
$days = (int)round(($ed - $sd) / 86400) + 1;
if ($days < 1) $days = 1;

// Validar contra disponibilidad (si existe)
$stmtA = $db->prepare("SELECT * FROM availability WHERE device_id = :device_id");
$stmtA->execute([':device_id' => $device_id]);
$avail = $stmtA->fetchAll(PDO::FETCH_ASSOC);

$allowed = true;
if ($avail) {
    $allowed = false;
    foreach ($avail as $a) {
        if ($start_date >= $a['start_date'] && $end_date <= $a['end_date']) {
            $allowed = true;
            break;
        }
    }
}

// Validar contra reservas pendientes / confirmadas que se solapen
$stmtB = $db->prepare("SELECT COUNT(*) AS c FROM bookings 
    WHERE device_id = :device_id 
    AND status IN ('pending','confirmed')
    AND NOT (end_date < :start_date OR start_date > :end_date)");
$stmtB->execute([
    ':device_id' => $device_id,
    ':start_date' => $start_date,
    ':end_date' => $end_date
]);
$rowB = $stmtB->fetch(PDO::FETCH_ASSOC);
$hasConflict = (int)$rowB['c'] > 0;

if (!$allowed || $hasConflict) {
    include __DIR__ . '/header.php';
    ?>
    <div class="container">
        <div class="box">
            <h2>No se pudo generar la reserva</h2>
            <p>El soporte no está disponible en el rango de fechas seleccionado.</p>
            <p>Probá con otras fechas o consultá con Prisa Static para más información.</p>
            <p><a href="device_view.php?id=<?php echo (int)$device_id; ?>" class="badge">Volver al soporte</a></p>
        </div>
    </div>
    <?php
    include __DIR__ . '/footer.php';
    exit();
}

// Calcular precio estimado
$daily = 0;
if (!empty($device['price_day'])) {
    $daily = $device['price_day'];
} elseif (!empty($device['price_month'])) {
    $daily = $device['price_month'] / 30.0;
} elseif (!empty($device['price_week'])) {
    $daily = $device['price_week'] / 7.0;
}
$total = $daily * $days;

// Crear booking (pendiente de aceptación del media owner)
$stmtIns = $db->prepare("INSERT INTO bookings (device_id, user_id, start_date, end_date, total_price, status, created_at)
    VALUES (:device_id, :user_id, :start_date, :end_date, :total_price, :status, :created_at)");
$stmtIns->execute([
    ':device_id' => $device_id,
    ':user_id' => $user['id'],
    ':start_date' => $start_date,
    ':end_date' => $end_date,
    ':total_price' => $total,
    ':status' => 'pending',
    ':created_at' => date('c')
]);

$booking_id = $db->lastInsertId();

include __DIR__ . '/header.php';
?>
<div class="container">
    <div class="box">
        <h2>Solicitud de reserva enviada</h2>
        <p>Tu solicitud de reserva fue registrada. El media owner deberá <strong>aceptarla</strong> desde su panel y luego Prisa Static coordinará el pago.</p>

        <p><strong>Soporte:</strong> <?php echo htmlspecialchars($device['title']); ?><br>
        <strong>Dirección:</strong> <?php echo htmlspecialchars($device['address']); ?><br>
        <strong>Desde:</strong> <?php echo htmlspecialchars($start_date); ?><br>
        <strong>Hasta:</strong> <?php echo htmlspecialchars($end_date); ?><br>
        <strong>Total estimado:</strong> ARS <?php echo number_format($total, 0, ',', '.'); ?></p>

        <p>El pago será gestionado por <strong>Prisa Static</strong> por cuenta corriente o transferencia bancaria una vez que la reserva sea aceptada.</p>

        <p><a href="index.php" class="badge">Volver al marketplace</a></p>
    </div>
</div>
<?php include __DIR__ . '/footer.php'; ?>
