<?php
require_once __DIR__ . '/config.php';

try {
    // Create users table
    $db->exec("CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        email TEXT NOT NULL UNIQUE,
        password TEXT NOT NULL,
        role TEXT NOT NULL DEFAULT 'advertiser',
        created_at TEXT NOT NULL
    )");

    // Add status column to users (pending/aprobado/bloqueado)
    try {
        $db->exec("ALTER TABLE users ADD COLUMN status TEXT NOT NULL DEFAULT 'approved';");
    } catch (Exception $e) {
        // columna puede existir, ignorar error
    }

    // Create settings table
    $db->exec("CREATE TABLE IF NOT EXISTS settings (
        id INTEGER PRIMARY KEY CHECK (id = 1),
        platform_name TEXT,
        logo_path TEXT,
        contact_email TEXT,
        contact_phone TEXT,
        billing_info TEXT,
        about_html TEXT
    )");

    // Insert default settings row if not exists
    $stmtSettings = $db->query("SELECT COUNT(*) as c FROM settings");
    $rowSettings = $stmtSettings->fetch(PDO::FETCH_ASSOC);
    if ((int)$rowSettings['c'] === 0) {
        $insSettings = $db->prepare("INSERT INTO settings (id, platform_name, contact_email, contact_phone, billing_info, about_html) 
            VALUES (1, :platform_name, :contact_email, :contact_phone, :billing_info, :about_html)");
        $insSettings->execute([
            ':platform_name' => 'Prisa Static',
            ':contact_email' => 'comercial@prisa-static.test',
            ':contact_phone' => '',
            ':billing_info' => '',
            ':about_html' => 'Plataforma de inventario estático OOH gestionada por Prisa.'
        ]);
    }


    // Create devices table
    $db->exec("CREATE TABLE IF NOT EXISTS devices (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        owner_id INTEGER NOT NULL,
        title TEXT NOT NULL,
        type TEXT,
        width REAL,
        height REAL,
        description TEXT,
        address TEXT,
        lat REAL,
        lng REAL,
        price_month REAL,
        price_week REAL,
        price_day REAL,
        main_image TEXT,
        created_at TEXT NOT NULL,
        FOREIGN KEY(owner_id) REFERENCES users(id)
    )");

    // Create bookings table
    $db->exec("CREATE TABLE IF NOT EXISTS bookings (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        device_id INTEGER NOT NULL,
        user_id INTEGER NOT NULL,
        start_date TEXT NOT NULL,
        end_date TEXT NOT NULL,
        total_price REAL NOT NULL,
        status TEXT NOT NULL DEFAULT 'pending',
        created_at TEXT NOT NULL,
        FOREIGN KEY(device_id) REFERENCES devices(id),
        FOREIGN KEY(user_id) REFERENCES users(id)
    )");

    // Create images table
    $db->exec("CREATE TABLE IF NOT EXISTS images (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        device_id INTEGER NOT NULL,
        path TEXT NOT NULL,
        FOREIGN KEY(device_id) REFERENCES devices(id)
    )");

    // Create availability table
    $db->exec("CREATE TABLE IF NOT EXISTS availability (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        device_id INTEGER NOT NULL,
        start_date TEXT NOT NULL,
        end_date TEXT NOT NULL,
        FOREIGN KEY(device_id) REFERENCES devices(id)
    );");

    // Create default admin if not exists
    $stmt = $db->prepare("SELECT COUNT(*) as c FROM users WHERE email = :email");
    $adminEmail = 'admin@prisastatic.com';
    $stmt->execute([':email' => $adminEmail]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ((int)$row['c'] === 0) {
        $password = password_hash('admin123', PASSWORD_DEFAULT);
        $now = date('c');
        $ins = $db->prepare("INSERT INTO users (name, email, password, role, created_at) VALUES (:name, :email, :password, :role, :created_at)");
        $ins->execute([
            ':name' => 'Admin Prisa Static',
            ':email' => $adminEmail,
            ':password' => $password,
            ':role' => 'admin',
            ':created_at' => $now
        ]);
        echo 'Database initialized and admin user created (admin@prisastatic.com / admin123).';
    } else {
        echo 'Database already initialized.';
    }

} catch (Exception $e) {
    echo 'Error initializing database: ' . $e->getMessage();
}
?>
