<?php
require_once __DIR__ . '/config.php';
require_login();
require_role('owner');

$user = current_user();
$error = '';
$success = '';

if (!is_dir(__DIR__ . '/uploads')) {
    mkdir(__DIR__ . '/uploads', 0775, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $type = trim($_POST['type'] ?? '');
    $width = $_POST['width'] ?? null;
    $height = $_POST['height'] ?? null;
    $description = trim($_POST['description'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $price_month = $_POST['price_month'] ?? null;
    $price_week = $_POST['price_week'] ?? null;
    $price_day = $_POST['price_day'] ?? null;
    $lat = $_POST['lat'] ?? null;
    $lng = $_POST['lng'] ?? null;

    $main_image = null;

    if (isset($_FILES['main_image']) && $_FILES['main_image']['error'] === UPLOAD_ERR_OK) {
        $tmp = $_FILES['main_image']['tmp_name'];
        $name = basename($_FILES['main_image']['name']);
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg','jpeg','png','webp'])) {
            $newName = 'device_' . time() . '_' . mt_rand(1000,9999) . '.' . $ext;
            $dest = __DIR__ . '/uploads/' . $newName;
            if (move_uploaded_file($tmp, $dest)) {
                $main_image = $newName;
            }
        }
    }

    if (!$title || !$address) {
        $error = 'Título y dirección son obligatorios.';
    } else {
        $stmt = $db->prepare("INSERT INTO devices 
            (owner_id, title, type, width, height, description, address, lat, lng, price_month, price_week, price_day, main_image, created_at)
            VALUES (:owner_id, :title, :type, :width, :height, :description, :address, :lat, :lng, :price_month, :price_week, :price_day, :main_image, :created_at)");
        $stmt->execute([
            ':owner_id' => $user['id'],
            ':title' => $title,
            ':type' => $type,
            ':width' => $width ?: null,
            ':height' => $height ?: null,
            ':description' => $description,
            ':address' => $address,
            ':lat' => $lat !== '' ? $lat : null,
            ':lng' => $lng !== '' ? $lng : null,
            ':price_month' => $price_month ?: null,
            ':price_week' => $price_week ?: null,
            ':price_day' => $price_day ?: null,
            ':main_image' => $main_image,
            ':created_at' => date('c')
        ]);
        $success = 'Soporte publicado correctamente.';
    }
}

include __DIR__ . '/header.php';
?>
<form class="standard" method="post" enctype="multipart/form-data">
    <h2>Publicar soporte estático</h2>

    <?php if ($error): ?>
        <div class="alert error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert success"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <label>Título del soporte</label>
    <input type="text" name="title" required placeholder="Ej: Valla 12x4 Av. 9 de Julio y Corrientes">

    <label>Tipo</label>
    <select name="type">
        <option value="">Seleccionar</option>
        <option value="Valla">Valla</option>
        <option value="Refugio">Refugio</option>
        <option value="Mupi">Mupi</option>
        <option value="Frontlight">Frontlight</option>
        <option value="Backlight">Backlight</option>
        <option value="Gigantografía">Gigantografía</option>
    </select>

    <label>Medidas (metros)</label>
    <div class="flex gap-16">
        <input type="number" step="0.01" name="width" placeholder="Ancho">
        <input type="number" step="0.01" name="height" placeholder="Alto">
    </div>

    <label>Descripción</label>
    <textarea name="description" rows="4" placeholder="Descripción comercial, flujo de personas, proximidad a puntos de interés..."></textarea>

    <label>Dirección</label>
    <input type="text" name="address" id="addressField" required placeholder="Ej: Av. 9 de Julio 1234, CABA">

    <input type="hidden" name="lat" id="latField">
    <input type="hidden" name="lng" id="lngField">

    <button type="button" class="btn-secondary" onclick="geocodeAddress()">Buscar en mapa</button>

    <div class="map-container">
        <div id="mapCreate"></div>
    </div>
    <p class="calendar-note">Usamos el mapa solo como referencia visual para anunciantes. Reemplazá el token de Mapbox en el código por el tuyo.</p>

    <label>Tarifas (ARS)</label>
    <div class="flex gap-16">
        <input type="number" step="1" name="price_month" placeholder="Mensual">
        <input type="number" step="1" name="price_week" placeholder="Semanal">
        <input type="number" step="1" name="price_day" placeholder="Diaria">
    </div>

    <label>Imagen principal</label>
    <input type="file" name="main_image" accept="image/*">

    <button type="submit">Publicar soporte</button>
</form>

<script>
// Token de Mapbox: reemplazar por el tuyo
const MAPBOX_TOKEN = 'TU_TOKEN_DE_MAPBOX_AQUI';

let mapCreate;
let markerCreate;

function initCreateMap() {
    if (!mapboxgl) return;
    mapboxgl.accessToken = MAPBOX_TOKEN;
    mapCreate = new mapboxgl.Map({
        container: 'mapCreate',
        style: 'mapbox://styles/mapbox/streets-v11',
        center: [-58.3816, -34.6037], // CABA por defecto
        zoom: 10
    });
}

function geocodeAddress() {
    const address = document.getElementById('addressField').value;
    if (!address) return;
    if (!MAPBOX_TOKEN || MAPBOX_TOKEN === 'TU_TOKEN_DE_MAPBOX_AQUI') {
        alert('Configurá tu token de Mapbox en device_new.php para usar el mapa.');
        return;
    }
    const url = 'https://api.mapbox.com/geocoding/v5/mapbox.places/' + encodeURIComponent(address) + '.json?limit=1&access_token=' + MAPBOX_TOKEN;
    fetch(url)
        .then(r => r.json())
        .then(data => {
            if (!data.features || !data.features.length) {
                alert('No encontramos esa dirección en el mapa.');
                return;
            }
            const [lng, lat] = data.features[0].center;
            document.getElementById('latField').value = lat;
            document.getElementById('lngField').value = lng;

            if (!mapCreate) {
                initCreateMap();
                mapCreate.on('load', () => {
                    setMarker(lat, lng);
                });
            } else {
                setMarker(lat, lng);
            }
        })
        .catch(() => alert('Error consultando el mapa.'));
}

function setMarker(lat, lng) {
    if (!mapCreate) return;
    if (markerCreate) {
        markerCreate.setLngLat([lng, lat]);
    } else {
        markerCreate = new mapboxgl.Marker().setLngLat([lng, lat]).addTo(mapCreate);
    }
    mapCreate.flyTo({ center: [lng, lat], zoom: 14 });
}

document.addEventListener('DOMContentLoaded', initCreateMap);
</script>

<?php include __DIR__ . '/footer.php'; ?>
