<?php
require_once __DIR__ . '/config.php';
$user = current_user();
// Cargar configuración de plataforma
$settingsStmt = $db->query("SELECT * FROM settings WHERE id = 1");
$settings = $settingsStmt->fetch(PDO::FETCH_ASSOC) ?: [];
$platformName = $settings['platform_name'] ?? 'Prisa Static';
$logoPath = $settings['logo_path'] ?? null;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Prisa Static</title>
    <link rel="stylesheet" href="styles.css">
    <!-- Mapbox GL JS (for mapas de ubicación) -->
    <link href="https://api.mapbox.com/mapbox-gl-js/v2.15.0/mapbox-gl.css" rel="stylesheet" />
    <script src="https://api.mapbox.com/mapbox-gl-js/v2.15.0/mapbox-gl.js"></script>
</head>
<body>
<header>
    <div class="logo">
    <a href="index.php">
        <?php if ($logoPath && file_exists(__DIR__ . '/' . $logoPath)): ?>
            <img src="<?php echo htmlspecialchars($logoPath); ?>" alt="<?php echo htmlspecialchars($platformName); ?>" style="height:32px;vertical-align:middle;">
        <?php else: ?>
            <?php echo htmlspecialchars($platformName); ?>
        <?php endif; ?>
    </a>
</div>
    <nav>
        <a href="index.php">Marketplace</a>
        <?php if ($user && $user['role'] === 'owner'): ?>
            <a href="owner_dashboard.php">Mis soportes</a>
            <a href="device_new.php">Publicar soporte</a>
        <?php endif; ?>
        <?php if ($user && $user['role'] === 'admin'): ?>
            <a href="admin_dashboard.php">Admin</a>
            <a href="admin_settings.php">Configuración</a>
        <?php endif; ?>
        <?php if ($user): ?>
            <a href="logout.php">Salir (<?php echo htmlspecialchars($user['name']); ?>)</a>
        <?php else: ?>
            <a href="login.php">Ingresar</a>
            <a href="register.php" class="primary">Crear cuenta</a>
        <?php endif; ?>
    </nav>
</header>
