<?php
require_once __DIR__ . '/config.php';
require_login();
require_role('owner');

$user = current_user();

// Cambiar estado de reservas (aceptar / rechazar)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['booking_id'], $_POST['action'])) {
    $bookingId = (int)$_POST['booking_id'];
    $action = $_POST['action'] === 'accept' ? 'confirmed' : 'rejected';

    // Solo permitir si el booking corresponde a un dispositivo de este owner
    $stmtCheck = $db->prepare("SELECT b.id FROM bookings b 
        JOIN devices d ON d.id = b.device_id
        WHERE b.id = :bid AND d.owner_id = :owner LIMIT 1");
    $stmtCheck->execute([':bid' => $bookingId, ':owner' => $user['id']]);
    $row = $stmtCheck->fetch(PDO::FETCH_ASSOC);
    if ($row) {
        $stmtUp = $db->prepare("UPDATE bookings SET status = :status WHERE id = :id");
        $stmtUp->execute([':status' => $action, ':id' => $bookingId]);
    }
}

// Fetch devices of this owner
$stmt = $db->prepare("SELECT * FROM devices WHERE owner_id = :owner ORDER BY created_at DESC");
$stmt->execute([':owner' => $user['id']]);
$devices = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch bookings of their devices
$stmt2 = $db->prepare("SELECT b.*, d.title, u.name AS advertiser_name 
    FROM bookings b 
    JOIN devices d ON d.id = b.device_id
    JOIN users u ON u.id = b.user_id
    WHERE d.owner_id = :owner
    ORDER BY b.created_at DESC");
$stmt2->execute([':owner' => $user['id']]);
$bookings = $stmt2->fetchAll(PDO::FETCH_ASSOC);

include __DIR__ . '/header.php';
?>
<div class="container">
    <h2>Mis soportes</h2>
    <p>Publicá nuevos soportes estáticos y gestioná las reservas.</p>
    <p><a href="device_new.php" class="badge">+ Publicar nuevo soporte</a></p>

    <h3>Inventario publicado</h3>
    <table>
        <tr>
            <th>Título</th>
            <th>Tipo</th>
            <th>Ubicación</th>
            <th>Tarifa mensual</th>
            <th>Acciones</th>
        </tr>
        <?php foreach ($devices as $d): ?>
            <tr>
                <td><?php echo htmlspecialchars($d['title']); ?></td>
                <td><?php echo htmlspecialchars($d['type']); ?></td>
                <td><?php echo htmlspecialchars($d['address']); ?></td>
                <td>
                    <?php if ($d['price_month']): ?>
                        ARS <?php echo number_format($d['price_month'], 0, ',', '.'); ?>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
                <td>
                    <a href="device_view.php?id=<?php echo (int)$d['id']; ?>">Ver</a> · 
                    <a href="availability_edit.php?device_id=<?php echo (int)$d['id']; ?>">Disponibilidad</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3>Reservas recibidas</h3>
    <table>
        <tr>
            <th>Soporte</th>
            <th>Anunciante</th>
            <th>Desde</th>
            <th>Hasta</th>
            <th>Total</th>
            <th>Estado</th>
        </tr>
        <?php foreach ($bookings as $b): ?>
            <tr>
                <td><?php echo htmlspecialchars($b['title']); ?></td>
                <td><?php echo htmlspecialchars($b['advertiser_name']); ?></td>
                <td><?php echo htmlspecialchars($b['start_date']); ?></td>
                <td><?php echo htmlspecialchars($b['end_date']); ?></td>
                <td>ARS <?php echo number_format($b['total_price'], 0, ',', '.'); ?></td>
                <td>
                    <span class="tag"><?php echo htmlspecialchars($b['status']); ?></span>
                    <?php if ($b['status'] === 'pending'): ?>
                        <form method="post" style="display:inline-block;margin-left:6px;">
                            <input type="hidden" name="booking_id" value="<?php echo (int)$b['id']; ?>">
                            <button type="submit" name="action" value="accept" class="btn-secondary">Aceptar</button>
                            <button type="submit" name="action" value="reject" class="btn-secondary">Rechazar</button>
                        </form>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>
<?php include __DIR__ . '/footer.php'; ?>
