<?php
require_once __DIR__ . '/config.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'advertiser';

    if (!$name || !$email || !$password) {
        $error = 'Completá todos los campos obligatorios.';
    } else {
        try {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $cleanRole = in_array($role, ['owner','advertiser']) ? $role : 'advertiser';
            $status = $cleanRole === 'owner' ? 'pending' : 'approved';
            $stmt = $db->prepare("INSERT INTO users (name, email, password, role, status, created_at) VALUES (:name, :email, :password, :role, :status, :created_at)");
            $stmt->execute([
                ':name' => $name,
                ':email' => $email,
                ':password' => $hash,
                ':role' => $cleanRole,
                ':status' => $status,
                ':created_at' => date('c')
            ]);
            $success = $role === 'owner'
                ? 'Cuenta creada. Un administrador de Prisa debe aprobar tu cuenta de media owner antes de que puedas ingresar.'
                : 'Cuenta creada. Ahora podés ingresar.';
        } catch (Exception $e) {
            $error = 'Error al crear la cuenta (¿email ya registrado?).';
        }
    }
}

include __DIR__ . '/header.php';
?>
<form class="auth" method="post">
    <h2>Crear cuenta</h2>
    <p class="sub">Registrate para acceder al marketplace de soportes estáticos.</p>

    <?php if ($error): ?>
        <div class="alert error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert success"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <label>Nombre</label>
    <input type="text" name="name" required>

    <label>Email</label>
    <input type="email" name="email" required>

    <label>Contraseña</label>
    <input type="password" name="password" required>

    <label>Tipo de cuenta</label>
    <select name="role">
        <option value="advertiser">Anunciante</option>
        <option value="owner">Empresa de vía pública / Media owner</option>
    </select>

    <button type="submit">Crear cuenta</button>
</form>
<?php include __DIR__ . '/footer.php'; ?>
